<?php
// bot_handlers.php - هندلرهای پیام‌ها

// پنل ادمین
if ($text == '/admin' && $user_id == ADMIN_ID) {
    sendMessage($chat_id, "⚙️ <b>پنل مدیریت رباتساز</b>\n\nاز گزینه‌های زیر استفاده کنید:", getAdminKeyboard());
}

// ساخت ربات
elseif ($text == '🤖 ساخت ربات') {
    $user_points = getUserPoints($user_id);
    
    if ($user_points < POINTS_FOR_BOT_CREATION) {
        $needed = POINTS_FOR_BOT_CREATION - $user_points;
        sendMessage($chat_id, "❌ برای ساخت ربات نیاز به " . POINTS_FOR_BOT_CREATION . " امتیاز دارید.\n\n" .
                             "💎 امتیاز فعلی: $user_points\n" .
                             "📊 کمبود: $needed امتیاز\n\n" .
                             "💡 راه‌های کسب امتیاز:\n" .
                             "👥 هر رفرال: " . POINTS_PER_REFERRAL . " امتیاز\n\n" .
                             "از بخش رفرال لینک خود را به اشتراک بگذارید!", getMainKeyboard());
    } else {
        sendMessage($chat_id, "✅ شما واجد شرایط ساخت ربات هستید!\n\n" .
                             "💎 امتیاز شما: $user_points\n" .
                             "💰 هزینه ساخت: " . POINTS_FOR_BOT_CREATION . " امتیاز\n\n" .
                             "🤖 لطفاً توکن ربات خود را از @BotFather دریافت کرده و ارسال کنید:\n\n" .
                             "📝 <b>مراحل:</b>\n" .
                             "1️⃣ به @BotFather مراجعه کنید\n" .
                             "2️⃣ /newbot را ارسال کنید\n" .
                             "3️⃣ نام و username ربات را وارد کنید\n" .
                             "4️⃣ توکن دریافتی را اینجا ارسال کنید", getBotCreateKeyboard());
    }
}

// رفرال
elseif ($text == '👥 رفرال') {
    $referral_count = count($referrals[$user_id] ?? []);
    $user_points = getUserPoints($user_id);
    $bot_info = sendRequest('getMe');
    $bot_username = $bot_info['result']['username'] ?? 'bot';
    $referral_link = "https://t.me/$bot_username?start=$user_id";
    
    $referral_text = "👥 <b>سیستم رفرال</b>\n\n";
    $referral_text .= "🔗 <b>لینک رفرال شما:</b>\n";
    $referral_text .= "<code>$referral_link</code>\n\n";
    $referral_text .= "📊 <b>آمار:</b>\n";
    $referral_text .= "👤 تعداد رفرال‌ها: $referral_count\n";
    $referral_text .= "💎 کل امتیاز: $user_points\n";
    $referral_text .= "🎯 هر رفرال: " . POINTS_PER_REFERRAL . " امتیاز\n";
    $referral_text .= "🤖 هر ساخت ربات: " . POINTS_FOR_BOT_CREATION . " امتیاز\n\n";
    $referral_text .= "💡 <b>نکته:</b> لینک خود را در کانال‌ها و گروه‌ها به اشتراک بگذارید!";
    
    sendMessage($chat_id, $referral_text, getMainKeyboard());
}

// آمار من
elseif ($text == '📊 آمار من') {
    $user_bots = array_filter($bots, function($bot) use ($user_id) {
        return $bot['owner_id'] == $user_id;
    });
    
    $referral_count = count($referrals[$user_id] ?? []);
    $user_points = getUserPoints($user_id);
    $spent_points = $users[$user_id]['spent_points'] ?? 0;
    
    $stats = "📊 <b>آمار شما</b>\n\n";
    $stats .= "👤 نام: $first_name\n";
    $stats .= "🗓 تاریخ عضویت: " . $users[$user_id]['join_date'] . "\n";
    $stats .= "🤖 ربات‌های ساخته شده: " . count($user_bots) . "\n";
    $stats .= "👥 تعداد رفرال‌ها: $referral_count\n\n";
    $stats .= "💎 <b>امتیازات:</b>\n";
    $stats .= "💰 کل امتیاز: " . ($referral_count * POINTS_PER_REFERRAL + ($users[$user_id]['admin_bonus_points'] ?? 0)) . "\n";
    $stats .= "💸 امتیاز خرج شده: $spent_points\n";
    $stats .= "💎 امتیاز باقیمانده: $user_points\n\n";
    
    if (!empty($user_bots)) {
        $stats .= "🤖 <b>ربات‌های شما:</b>\n";
        foreach ($user_bots as $bot) {
            $stats .= "• " . $bot['bot_name'] . " (@" . $bot['bot_username'] . ")\n";
        }
    }
    
    sendMessage($chat_id, $stats, getMainKeyboard());
}

// ربات‌های من
elseif ($text == '🛠 ربات‌های من') {
    $user_bots = array_filter($bots, function($bot) use ($user_id) {
        return $bot['owner_id'] == $user_id;
    });
    
    if (empty($user_bots)) {
        sendMessage($chat_id, "❌ شما هنوز ربات نساخته‌اید!\n\nابتدا " . POINTS_FOR_BOT_CREATION . " امتیاز جمع کنید و سپس ربات بسازید.", getMainKeyboard());
    } else {
        $bots_text = "🛠 <b>ربات‌های شما</b>\n\n";
        foreach ($user_bots as $bot_id => $bot) {
            $bots_text .= "🤖 <b>" . $bot['bot_name'] . "</b>\n";
            $bots_text .= "👤 Username: @" . $bot['bot_username'] . "\n";
            $bots_text .= "📅 تاریخ ساخت: " . $bot['created_date'] . "\n";
            $bots_text .= "🔗 فایل: bot_" . $bot_id . ".php\n";
            $bots_text .= "⚙️ وضعیت: " . ($bot['is_active'] ? '✅ فعال' : '❌ غیرفعال') . "\n\n";
        }
        $bots_text .= "💡 برای مدیریت ربات‌های خود، فایل‌هایشان را دانلود کرده و روی هاست آپلود کنید.";
        
        sendMessage($chat_id, $bots_text, getMainKeyboard());
    }
}

// راهنما
elseif ($text == '📚 راهنما') {
    $help = "📚 <b>راهنمای کامل رباتساز</b>\n\n";
    $help .= "🔹 <b>مراحل ساخت ربات:</b>\n";
    $help .= "1️⃣ " . POINTS_FOR_BOT_CREATION . " امتیاز جمع کنید (از طریق رفرال)\n";
    $help .= "2️⃣ از @BotFather ربات جدید بسازید\n";
    $help .= "3️⃣ توکن ربات را در رباتساز وارد کنید\n";
    $help .= "4️⃣ فایل ربات را دانلود و روی هاست آپلود کنید\n\n";
    $help .= "💎 <b>سیستم امتیازی:</b>\n";
    $help .= "👥 هر رفرال: " . POINTS_PER_REFERRAL . " امتیاز\n";
    $help .= "🤖 هر ساخت ربات: " . POINTS_FOR_BOT_CREATION . " امتیاز کسر می‌شود\n\n";
    $help .= "🔹 <b>امکانات ربات ساخته شده:</b>\n";
    $help .= "• ری‌اکشن خودکار به پست‌های کانال\n";
    $help .= "• پنل مدیریت اختصاصی\n";
    $help .= "• اضافه/حذف ری‌اکشن‌ها\n";
    $help .= "• آمارگیری کامل\n";
    $help .= "• تنظیم تعداد ری‌اکشن‌ها\n\n";
    $help .= "🔹 <b>نحوه راه‌اندازی:</b>\n";
    $help .= "1️⃣ فایل bot_XXX.php را روی هاست آپلود کنید\n";
    $help .= "2️⃣ webhook را فعال کنید: yoursite.com/bot_XXX.php?set_webhook\n";
    $help .= "3️⃣ ربات را به کانال اضافه و ادمین کنید\n";
    $help .= "4️⃣ از ربات لذت ببرید! 🎉\n\n";
    $help .= "📢 <b>جوین اجباری:</b>\n";
    foreach (FORCE_JOIN_CHANNELS as $channel) {
        $help .= "• $channel\n";
    }
    
    sendMessage($chat_id, $help, getMainKeyboard());
}

// پشتیبانی
elseif ($text == '☎️ پشتیبانی') {
    $support = "☎️ <b>پشتیبانی</b>\n\n";
    $support .= "🆔 برای دریافت پشتیبانی با ادمین در ارتباط باشید:\n";
    $support .= "👤 ادمین: @YourSupportUsername\n\n";
    $support .= "🔹 <b>موارد پشتیبانی:</b>\n";
    $support .= "• مشکلات فنی ربات‌ها\n";
    $support .= "• راهنمایی راه‌اندازی\n";
    $support .= "• سوالات عمومی\n";
    $support .= "• گزارش باگ\n\n";
    $support .= "⏰ <b>ساعت کاری:</b> 9 صبح تا 9 شب";
    
    sendMessage($chat_id, $support, getMainKeyboard());
}

// بخش‌های مدیریت ادمین
elseif ($user_id == ADMIN_ID) {
    if ($text == '➕ افزایش امتیاز') {
        sendMessage($chat_id, "👤 ID کاربر و مقدار امتیاز را با فرمت زیر ارسال کنید:\n\n<code>add_points USER_ID POINTS</code>\n\nمثال: <code>add_points 123456789 10</code>", getAdminKeyboard());
    }
    
    elseif ($text == '➖ کسر امتیاز') {
        sendMessage($chat_id, "👤 ID کاربر و مقدار امتیاز را با فرمت زیر ارسال کنید:\n\n<code>remove_points USER_ID POINTS</code>\n\nمثال: <code>remove_points 123456789 5</code>", getAdminKeyboard());
    }
    
    elseif ($text == '📢 پیام همگانی') {
        $users[$user_id]['waiting_broadcast'] = true;
        saveUsers($users);
        sendMessage($chat_id, "📢 پیام مورد نظر برای ارسال همگانی را ارسال کنید:", getAdminKeyboard());
    }
    
    elseif ($text == '📊 آمار کامل') {
        $total_users = count($users);
        $total_bots = count($bots);
        $active_bots = count(array_filter($bots, function($bot) {
            return $bot['is_active'];
        }));
        $total_referrals = array_sum(array_map('count', $referrals));
        $total_banned = count($banned_users);
        
        $admin_stats = "📊 <b>آمار کل رباتساز</b>\n\n";
        $admin_stats .= "👥 کل کاربران: $total_users\n";
        $admin_stats .= "🤖 کل ربات‌ها: $total_bots\n";
        $admin_stats .= "✅ ربات‌های فعال: $active_bots\n";
        $admin_stats .= "🔗 کل رفرال‌ها: $total_referrals\n";
        $admin_stats .= "🚫 کاربران بن شده: $total_banned\n\n";
        
        $total_earned_points = $total_referrals * POINTS_PER_REFERRAL;
        $total_spent_points = array_sum(array_column($users, 'spent_points'));
        $admin_stats .= "💎 <b>آمار امتیازات:</b>\n";
        $admin_stats .= "💰 کل امتیاز کسب شده: $total_earned_points\n";
        $admin_stats .= "💸 کل امتیاز خرج شده: $total_spent_points\n";
        $admin_stats .= "💎 امتیاز باقیمانده: " . ($total_earned_points - $total_spent_points) . "\n\n";
        
        $admin_stats .= "📈 <b>آخرین کاربران:</b>\n";
        $recent_users = array_slice($users, -5, 5, true);
        foreach ($recent_users as $uid => $user) {
            $admin_stats .= "• " . $user['first_name'] . " ($uid) - " . getUserPoints($uid) . " امتیاز\n";
        }
        
        sendMessage($chat_id, $admin_stats, getAdminKeyboard());
    }
    
    elseif ($text == '🚫 بن کاربر') {
        sendMessage($chat_id, "👤 ID کاربر مورد نظر برای بن را ارسال کنید:\n\n<code>ban USER_ID</code>\n\nمثال: <code>ban 123456789</code>", getAdminKeyboard());
    }
    
    elseif ($text == '✅ آنبن کاربر') {
        sendMessage($chat_id, "👤 ID کاربر مورد نظر برای آنبن را ارسال کنید:\n\n<code>unban USER_ID</code>\n\nمثال: <code>unban 123456789</code>", getAdminKeyboard());
    }
    
    elseif ($text == '🤖 آمار ربات‌ها') {
        $bot_stats = "🤖 <b>آمار ربات‌ها</b>\n\n";
        $bot_stats .= "📊 تعداد کل: " . count($bots) . "\n";
        $bot_stats .= "✅ فعال: " . count(array_filter($bots, function($b) { return $b['is_active']; })) . "\n";
        $bot_stats .= "❌ غیرفعال: " . count(array_filter($bots, function($b) { return !$b['is_active']; })) . "\n\n";
        
        $bot_stats .= "📈 <b>آخرین ربات‌های ساخته شده:</b>\n";
        $recent_bots = array_slice($bots, -5, 5, true);
        foreach ($recent_bots as $bot_id => $bot) {
            $owner_name = $users[$bot['owner_id']]['first_name'] ?? 'نامشخص';
            $bot_stats .= "• " . $bot['bot_name'] . " (@" . $bot['bot_username'] . ")\n";
            $bot_stats .= "  👤 سازنده: $owner_name (" . $bot['owner_id'] . ")\n";
            $bot_stats .= "  📅 تاریخ: " . $bot['created_date'] . "\n\n";
        }
        
        sendMessage($chat_id, $bot_stats, getAdminKeyboard());
    }
    
    elseif ($text == '🔙 منوی اصلی') {
        $user_points = getUserPoints($user_id);
        
        $welcome = "🤖 <b>خوش آمدید به رباتساز ری‌اکشن زن!</b>\n\n";
        $welcome .= "👋 سلام $first_name\n\n";
        $welcome .= "💎 امتیاز شما: $user_points\n";
        $welcome .= "⚙️ <b>پنل ادمین:</b> /admin";
        
        sendMessage($chat_id, $welcome, getMainKeyboard());
    }
    
    // پردازش دستورات ادمین
    elseif (preg_match('/^add_points (\d+) (\d+)$/', $text, $matches)) {
        $target_user = $matches[1];
        $points = intval($matches[2]);
        
        if (isset($users[$target_user])) {
            if (!isset($users[$target_user]['admin_bonus_points'])) {
                $users[$target_user]['admin_bonus_points'] = 0;
            }
            $users[$target_user]['admin_bonus_points'] += $points;
            saveUsers($users);
            
            $target_name = $users[$target_user]['first_name'];
            sendMessage($chat_id, "✅ $points امتیاز به کاربر $target_name ($target_user) اضافه شد!", getAdminKeyboard());
            sendMessage($target_user, "🎉 ادمین $points امتیاز به حساب شما اضافه کرد!\n💎 امتیاز جدید شما: " . getUserPoints($target_user));
        } else {
            sendMessage($chat_id, "❌ کاربر یافت نشد!", getAdminKeyboard());
        }
    }
    
    elseif (preg_match('/^remove_points (\d+) (\d+)$/', $text, $matches)) {
        $target_user = $matches[1];
        $points = intval($matches[2]);
        
        if (isset($users[$target_user])) {
            $users[$target_user]['spent_points'] = ($users[$target_user]['spent_points'] ?? 0) + $points;
            saveUsers($users);
            
            $target_name = $users[$target_user]['first_name'];
            sendMessage($chat_id, "✅ $points امتیاز از کاربر $target_name ($target_user) کسر شد!", getAdminKeyboard());
            sendMessage($target_user, "⚠️ ادمین $points امتیاز از حساب شما کسر کرد!\n💎 امتیاز باقیمانده: " . getUserPoints($target_user));
        } else {
            sendMessage($chat_id, "❌ کاربر یافت نشد!", getAdminKeyboard());
        }
    }
    
    elseif (preg_match('/^ban (\d+)$/', $text, $matches)) {
        $target_user = $matches[1];
        
        if (!in_array($target_user, $banned_users)) {
            $banned_users[] = $target_user;
            saveBannedUsers($banned_users);
            
            $target_name = $users[$target_user]['first_name'] ?? 'نامشخص';
            sendMessage($chat_id, "🚫 کاربر $target_name ($target_user) بن شد!", getAdminKeyboard());
            sendMessage($target_user, "🚫 شما از استفاده از این ربات محروم شده‌اید!");
        } else {
            sendMessage($chat_id, "⚠️ این کاربر قبلاً بن شده است!", getAdminKeyboard());
        }
    }
    
    elseif (preg_match('/^unban (\d+)$/', $text, $matches)) {
        $target_user = $matches[1];
        
        if (in_array($target_user, $banned_users)) {
            $banned_users = array_filter($banned_users, function($id) use ($target_user) {
                return $id != $target_user;
            });
            $banned_users = array_values($banned_users);
            saveBannedUsers($banned_users);
            
            $target_name = $users[$target_user]['first_name'] ?? 'نامشخص';
            sendMessage($chat_id, "✅ کاربر $target_name ($target_user) آنبن شد!", getAdminKeyboard());
            sendMessage($target_user, "✅ شما دوباره می‌توانید از ربات استفاده کنید!");
        } else {
            sendMessage($chat_id, "⚠️ این کاربر بن نیست!", getAdminKeyboard());
        }
    }
    
    // پردازش پیام همگانی
    elseif (isset($users[$user_id]['waiting_broadcast'])) {
        $broadcast_msg = $text;
        $sent_count = 0;
        $failed_count = 0;
        
        foreach ($users as $uid => $user) {
            if (!in_array($uid, $banned_users)) {
                if (sendMessage($uid, $broadcast_msg)) {
                    $sent_count++;
                } else {
                    $failed_count++;
                }
                usleep(100000); // تاخیر 0.1 ثانیه
            }
        }
        
        sendMessage($chat_id, "✅ پیام همگانی ارسال شد!\n\n✅ موفق: $sent_count\n❌ ناموفق: $failed_count", getAdminKeyboard());
        unset($users[$user_id]['waiting_broadcast']);
        saveUsers($users);
    }
}

// بررسی جوین اجباری برای کاربران عادی
elseif ($text == '✅ عضو شدم') {
    if (checkForceJoin($user_id)) {
        $user_points = getUserPoints($user_id);
        
        $welcome = "✅ تبریک! حالا می‌توانید از تمام امکانات ربات استفاده کنید.\n\n";
        $welcome .= "💎 امتیاز شما: $user_points\n";
        $welcome .= "🎯 برای ساخت ربات: " . POINTS_FOR_BOT_CREATION . " امتیاز نیاز دارید";
        
        sendMessage($chat_id, $welcome, getMainKeyboard());
    } else {
        sendMessage($chat_id, "❌ هنوز در تمام کانال‌ها عضو نشده‌اید!\n\nلطفاً ابتدا در همه کانال‌ها عضو شوید.", getForceJoinKeyboard());
    }
}

// پردازش توکن ربات
elseif (preg_match('/^\d+:[A-Za-z0-9_-]+$/', $text)) {
    include 'bot_generator.php';
}
?>