<?php
// bot_generator.php - تولید کننده ربات‌ها

$bot_token = $text;
$user_points = getUserPoints($user_id);

// بررسی امتیاز کافی
if ($user_points < POINTS_FOR_BOT_CREATION) {
    sendMessage($chat_id, "❌ امتیاز کافی ندارید!\n\n💎 امتیاز شما: $user_points\n🎯 مورد نیاز: " . POINTS_FOR_BOT_CREATION, getMainKeyboard());
    exit;
}

// بررسی معتبر بودن توکن
$bot_info = sendRequest('getMe', [], $bot_token);

if (!$bot_info['ok']) {
    sendMessage($chat_id, "❌ توکن نامعتبر است! لطفاً توکن صحیح را از @BotFather دریافت کرده و ارسال کنید.", getBotCreateKeyboard());
} else {
    $bot_username = $bot_info['result']['username'];
    $bot_name = $bot_info['result']['first_name'];
    
    // بررسی تکراری نبودن ربات
    $existing_bot = array_filter($bots, function($bot) use ($bot_username) {
        return $bot['bot_username'] == $bot_username;
    });
    
    if (!empty($existing_bot)) {
        sendMessage($chat_id, "❌ این ربات قبلاً در سیستم ثبت شده است!", getBotCreateKeyboard());
    } else {
        // کسر امتیاز
        $users[$user_id]['spent_points'] = ($users[$user_id]['spent_points'] ?? 0) + POINTS_FOR_BOT_CREATION;
        $users[$user_id]['bots_created']++;
        
        // ایجاد ربات جدید
        $bot_id = time() . rand(100, 999);
        
        $bots[$bot_id] = [
            'owner_id' => $user_id,
            'bot_token' => $bot_token,
            'bot_name' => $bot_name,
            'bot_username' => $bot_username,
            'created_date' => date('Y-m-d H:i:s'),
            'is_active' => true
        ];
        
        // تولید فایل ربات
        $bot_code = generateBotCode($bot_token, $user_id, $bot_id);
        file_put_contents("bot_$bot_id.php", $bot_code);
        
        saveBots($bots);
        saveUsers($users);
        
        $new_points = getUserPoints($user_id);
        
        $success = "🎉 <b>ربات شما با موفقیت ساخته شد!</b>\n\n";
        $success .= "🤖 نام ربات: $bot_name\n";
        $success .= "👤 Username: @$bot_username\n";
        $success .= "📁 نام فایل: bot_$bot_id.php\n\n";
        $success .= "💎 <b>امتیازات:</b>\n";
        $success .= "💸 امتیاز کسر شده: " . POINTS_FOR_BOT_CREATION . "\n";
        $success .= "💰 امتیاز باقیمانده: $new_points\n\n";
        $success .= "🔧 <b>مراحل راه‌اندازی:</b>\n";
        $success .= "1️⃣ فایل bot_$bot_id.php را دانلود کنید\n";
        $success .= "2️⃣ روی هاست خود آپلود کنید\n";
        $success .= "3️⃣ برای فعال‌سازی webhook این لینک را باز کنید:\n";
        $success .= "<code>yoursite.com/bot_$bot_id.php?set_webhook</code>\n\n";
        $success .= "4️⃣ ربات را به کانال‌هایتان اضافه کنید\n";
        $success .= "5️⃣ ربات را ادمین کنید (مجوز ارسال پیام و واکنش)\n\n";
        $success .= "✅ ربات شما آماده استفاده است!";
        
        sendMessage($chat_id, $success, getMainKeyboard());
        
        // اطلاع به ادمین اصلی
        $admin_msg = "🆕 ربات جدید ساخته شد!\n\n";
        $admin_msg .= "👤 سازنده: $first_name ($user_id)\n";
        $admin_msg .= "🤖 ربات: $bot_name (@$bot_username)\n";
        $admin_msg .= "📁 فایل: bot_$bot_id.php\n";
        $admin_msg .= "💎 امتیاز کسر شده: " . POINTS_FOR_BOT_CREATION . "\n";
        $admin_msg .= "💰 امتیاز باقیمانده: $new_points\n";
        $admin_msg .= "📅 تاریخ: " . date('Y-m-d H:i:s');
        
        sendMessage(ADMIN_ID, $admin_msg);
    }
}

// تولید فایل ربات جدید
function generateBotCode($bot_token, $admin_id, $bot_id) {
    $force_channels = json_encode(FORCE_JOIN_CHANNELS);
    
    $template = '<?php
error_reporting(0);
ini_set(\'display_errors\', 0);

define(\'BOT_TOKEN\', \'' . $bot_token . '\');
define(\'ADMIN_ID\', ' . $admin_id . ');
define(\'WEBHOOK_URL\', \'https://your-domain.com/bot_' . $bot_id . '.php\');

// جوین اجباری - کانال‌های رباتساز
define(\'FORCE_JOIN_CHANNELS\', ' . $force_channels . ');

if (!file_exists(\'bot_data_' . $bot_id . '.json\')) {
    file_put_contents(\'bot_data_' . $bot_id . '.json\', json_encode([
        \'channels\' => [],
        \'reactions\' => [\'❤️\'],
        \'max_reactions_per_post\' => 0,
        \'stats\' => [\'total_reactions\' => 0, \'active_channels\' => 0]
    ]));
}

function getData() {
    return json_decode(file_get_contents(\'bot_data_' . $bot_id . '.json\'), true) ?: [];
}

function saveData($data) {
    file_put_contents(\'bot_data_' . $bot_id . '.json\', json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

function sendRequest($method, $parameters = []) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/" . $method;
    
    $options = [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($parameters),
        CURLOPT_HTTPHEADER => [\'Content-Type: application/json\'],
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_TIMEOUT => 30
    ];
    
    $curl = curl_init();
    curl_setopt_array($curl, $options);
    $result = curl_exec($curl);
    $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);
    
    if ($result === false || $http_code !== 200) {
        return [\'ok\' => false, \'description\' => \'Network error\'];
    }
    
    return json_decode($result, true) ?: [\'ok\' => false, \'description\' => \'Invalid response\'];
}

function sendMessage($chat_id, $text, $reply_markup = null) {
    $params = [
        \'chat_id\' => $chat_id,
        \'text\' => $text,
        \'parse_mode\' => \'HTML\'
    ];
    
    if ($reply_markup) {
        $params[\'reply_markup\'] = $reply_markup;
    }
    
    return sendRequest(\'sendMessage\', $params);
}

function sendReaction($chat_id, $message_id, $reaction) {
    return sendRequest(\'setMessageReaction\', [
        \'chat_id\' => $chat_id,
        \'message_id\' => $message_id,
        \'reaction\' => [[\'type\' => \'emoji\', \'emoji\' => $reaction]]
    ]);
}

// بررسی جوین اجباری
function checkForceJoin($user_id) {
    foreach (FORCE_JOIN_CHANNELS as $channel) {
        $result = sendRequest(\'getChatMember\', [
            \'chat_id\' => $channel,
            \'user_id\' => $user_id
        ]);
        
        if (!$result[\'ok\'] || !in_array($result[\'result\'][\'status\'], [\'member\', \'administrator\', \'creator\'])) {
            return false;
        }
    }
    return true;
}

// کیبورد جوین اجباری
function getForceJoinKeyboard() {
    $keyboard = [];
    foreach (FORCE_JOIN_CHANNELS as $channel) {
        $keyboard[] = [[\'text\' => "عضویت در $channel", \'url\' => "https://t.me/" . ltrim($channel, \'@\')]];
    }
    $keyboard[] = [[\'text\' => \'✅ عضو شدم\', \'callback_data\' => \'check_join\']];
    
    return [\'inline_keyboard\' => $keyboard];
}

function getMainKeyboard() {
    return [
        \'keyboard\' => [
            [[\'text\' => \'📚 راهنما\'], [\'text\' => \'➕ اضافه کردن به کانال\']],
            [[\'text\' => \'⚙️ پنل مدیریت\']]
        ],
        \'resize_keyboard\' => true
    ];
}

function getAdminKeyboard() {
    return [
        \'keyboard\' => [
            [[\'text\' => \'🎯 اضافه کردن ری‌اکشن\'], [\'text\' => \'🗑 حذف ری‌اکشن\']],
            [[\'text\' => \'🔢 تنظیم تعداد ری‌اکشن\'], [\'text\' => \'📊 آمار\']],
            [[\'text\' => \'🔙 بازگشت\']]
        ],
        \'resize_keyboard\' => true
    ];
}

$input = file_get_contents(\'php://input\');
$update = json_decode($input, true);

if (!$update) {
    die(\'No update received\');
}

$data = getData();

// پردازش پیام‌ها
if (isset($update[\'message\'])) {
    $message = $update[\'message\'];
    $chat_id = $message[\'chat\'][\'id\'];
    $text = $message[\'text\'] ?? \'\';
    $user_id = $message[\'from\'][\'id\'];
    
    // بررسی جوین اجباری برای کاربران عادی (ادمین معاف)
    if (!checkForceJoin($user_id) && $user_id != ADMIN_ID) {
        $force_msg = "⚠️ <b>برای استفاده از ربات باید در کانال‌های زیر عضو شوید:</b>\\n\\n";
        foreach (FORCE_JOIN_CHANNELS as $channel) {
            $force_msg .= "📢 $channel\\n";
        }
        $force_msg .= "\\nپس از عضویت، دکمه \'عضو شدم\' را فشار دهید.";
        
        sendMessage($chat_id, $force_msg, getForceJoinKeyboard());
        exit;
    }
    
    if ($text == \'/start\') {
        $welcome = "🤖 <b>خوش آمدید به ربات ری‌اکشن زن!</b>\\n\\n";
        $welcome .= "این ربات می‌تواند به طور خودکار به پست‌های جدید کانال‌هایتان ری‌اکشن بزند.\\n\\n";
        $welcome .= "از منوی زیر استفاده کنید:";
        
        sendMessage($chat_id, $welcome, getMainKeyboard());
    }
    elseif ($text == \'📚 راهنما\') {
        $help = "📋 <b>راهنمای کامل ربات</b>\\n\\n";
        $help .= "🔹 <b>نحوه استفاده:</b>\\n";
        $help .= "1️⃣ ربات را به کانال اضافه کنید\\n";
        $help .= "2️⃣ ربات را ادمین کانال کنید\\n";
        $help .= "3️⃣ از پنل مدیریت ری‌اکشن‌ها را اضافه کنید\\n";
        $help .= "4️⃣ ربات خودکار ری‌اکشن می‌زند\\n\\n";
        $help .= "🔹 <b>ری‌اکشن‌های معتبر:</b>\\n";
        $help .= "❤️ 👍 👎 🔥 🥰 😁 😢 😮 😡 💩 👏 🤩 🤔 🤯 😱 🤬 😴 🤮 💀 👻 💊\\n\\n";
        $help .= "⚠️ <b>نکته مهم:</b> برای کارکرد ربات حتماً در کانال‌های زیر عضو باشید:\\n";
        foreach (FORCE_JOIN_CHANNELS as $channel) {
            $help .= "📢 $channel\\n";
        }
        
        sendMessage($chat_id, $help, getMainKeyboard());
    }
    elseif ($text == \'➕ اضافه کردن به کانال\') {
        $bot_info = sendRequest(\'getMe\');
        $bot_username = $bot_info[\'result\'][\'username\'] ?? \'unknown\';
        
        $add_info = "🔗 <b>نحوه اضافه کردن ربات به کانال</b>\\n\\n";
        $add_info .= "1️⃣ وارد کانال خود شوید\\n";
        $add_info .= "2️⃣ بر روی نام کانال کلیک کنید\\n";
        $add_info .= "3️⃣ گزینه \'مدیران\' را انتخاب کنید\\n";
        $add_info .= "4️⃣ روی \'اضافه کردن مدیر\' کلیک کنید\\n";
        $add_info .= "5️⃣ نام کاربری ربات: <code>@" . $bot_username . "</code>\\n";
        $add_info .= "6️⃣ ربات را ادمین کنید\\n\\n";
        $add_info .= "⚠️ <b>مهم:</b> مجوز \'ارسال پیام\' و \'واکنش به پیام\' را بدهید";
        
        sendMessage($chat_id, $add_info, getMainKeyboard());
    }
    elseif ($text == \'⚙️ پنل مدیریت\') {
        if ($user_id != ADMIN_ID) {
            sendMessage($chat_id, "❌ شما مجوز دسترسی به پنل ندارید!", getMainKeyboard());
        } else {
            sendMessage($chat_id, "🎛 <b>پنل مدیریت</b>\\n\\nاز گزینه‌های زیر استفاده کنید:", getAdminKeyboard());
        }
    }
    elseif ($text == \'🎯 اضافه کردن ری‌اکشن\' && $user_id == ADMIN_ID) {
        sendMessage($chat_id, "🎯 ری‌اکشن مورد نظر را ارسال کنید:\\n\\nری‌اکشن‌های معتبر: ❤️ 👍 👎 🔥 🥰 😁 😢 😮 😡 💩 👏 🤩 🤔 🤯 😱 🤬 😴 🤮 💀 👻 💊", getAdminKeyboard());
    }
    elseif ($text == \'🗑 حذف ری‌اکشن\' && $user_id == ADMIN_ID) {
        if (empty($data[\'reactions\'])) {
            sendMessage($chat_id, "❌ هیچ ری‌اکشنی برای حذف وجود ندارد!", getAdminKeyboard());
        } else {
            $reaction_list = "🗑 <b>ری‌اکشن‌های فعال:</b>\\n\\n";
            foreach ($data[\'reactions\'] as $index => $reaction) {
                $reaction_list .= ($index + 1) . ". $reaction\\n";
            }
            $reaction_list .= "\\nبرای حذف عبارت del_ + شماره را ارسال کنید\\nمثال: del_1";
            sendMessage($chat_id, $reaction_list, getAdminKeyboard());
        }
    }
    elseif ($text == \'🔢 تنظیم تعداد ری‌اکشن\' && $user_id == ADMIN_ID) {
        $max_reactions = count($data[\'reactions\']);
        sendMessage($chat_id, "🔢 تعداد ری‌اکشن را وارد کنید:\\n\\n" . 
                             "• حداکثر: $max_reactions\\n" . 
                             "• برای همه: 0\\n" . 
                             "• فعلی: " . ($data[\'max_reactions_per_post\'] ?? $max_reactions), 
                             getAdminKeyboard());
    }
    elseif ($text == \'📊 آمار\' && $user_id == ADMIN_ID) {
        $stats = "📊 <b>آمار ربات</b>\\n\\n";
        $stats .= "🎯 تعداد ری‌اکشن‌ها: " . count($data[\'reactions\']) . "\\n";
        $stats .= "📺 کانال‌های فعال: " . count($data[\'channels\']) . "\\n";
        $stats .= "⚡ کل ری‌اکشن‌ها: " . $data[\'stats\'][\'total_reactions\'] . "\\n";
        $stats .= "🔢 ری‌اکشن در هر پست: " . ($data[\'max_reactions_per_post\'] == 0 ? \'همه\' : $data[\'max_reactions_per_post\']) . "\\n\\n";
        
        if (!empty($data[\'reactions\'])) {
            $stats .= "🎯 <b>ری‌اکشن‌های فعلی:</b>\\n";
            foreach ($data[\'reactions\'] as $reaction) {
                $stats .= "• $reaction\\n";
            }
        }
        
        sendMessage($chat_id, $stats, getAdminKeyboard());
    }
    elseif ($text == \'🔙 بازگشت\') {
        sendMessage($chat_id, "🏠 منوی اصلی", getMainKeyboard());
    }
    elseif ($user_id == ADMIN_ID && in_array($text, [\'❤️\', \'👍\', \'👎\', \'🔥\', \'🥰\', \'😁\', \'😢\', \'😮\', \'😡\', \'💩\', \'👏\', \'🤩\', \'🤔\', \'🤯\', \'😱\', \'🤬\', \'😴\', \'🤮\', \'💀\', \'👻\', \'💊\'])) {
        if (!in_array($text, $data[\'reactions\'])) {
            $data[\'reactions\'][] = $text;
            saveData($data);
            sendMessage($chat_id, "✅ ری‌اکشن $text اضافه شد!", getAdminKeyboard());
        } else {
            sendMessage($chat_id, "⚠️ این ری‌اکشن قبلاً وجود دارد!", getAdminKeyboard());
        }
    }
    elseif ($user_id == ADMIN_ID && preg_match(\'/^del_(\\d+)$/\', $text, $matches)) {
        $index = intval($matches[1]) - 1;
        if (isset($data[\'reactions\'][$index])) {
            $removed = $data[\'reactions\'][$index];
            unset($data[\'reactions\'][$index]);
            $data[\'reactions\'] = array_values($data[\'reactions\']);
            saveData($data);
            sendMessage($chat_id, "✅ ری‌اکشن $removed حذف شد!", getAdminKeyboard());
        } else {
            sendMessage($chat_id, "❌ شماره نامعتبر!", getAdminKeyboard());
        }
    }
    elseif ($user_id == ADMIN_ID && is_numeric($text) && strpos($text, \'.\') === false) {
        $number = intval($text);
        $max_available = count($data[\'reactions\']);
        
        if ($number >= 0 && $number <= $max_available) {
            $data[\'max_reactions_per_post\'] = $number;
            saveData($data);
            
            if ($number == 0) {
                sendMessage($chat_id, "✅ تنظیم شد! همه ری‌اکشن‌ها زده می‌شود.", getAdminKeyboard());
            } else {
                sendMessage($chat_id, "✅ تنظیم شد! $number ری‌اکشن اول زده می‌شود.", getAdminKeyboard());
            }
        } else {
            sendMessage($chat_id, "❌ عدد نامعتبر! باید بین 0 تا $max_available باشد.", getAdminKeyboard());
        }
    }
    // بررسی جوین برای کاربران عادی
    elseif ($text == \'✅ عضو شدم\') {
        if (checkForceJoin($user_id)) {
            sendMessage($chat_id, "✅ تبریک! حالا می‌توانید از تمام امکانات ربات استفاده کنید.", getMainKeyboard());
        } else {
            sendMessage($chat_id, "❌ هنوز در تمام کانال‌ها عضو نشده‌اید!", getForceJoinKeyboard());
        }
    }
}
// پردازش callback query
elseif (isset($update[\'callback_query\'])) {
    $callback = $update[\'callback_query\'];
    $chat_id = $callback[\'message\'][\'chat\'][\'id\'];
    $user_id = $callback[\'from\'][\'id\'];
    
    if ($callback[\'data\'] == \'check_join\') {
        if (checkForceJoin($user_id)) {
            sendMessage($chat_id, "✅ تبریک! حالا می‌توانید از تمام امکانات ربات استفاده کنید.", getMainKeyboard());
        } else {
            sendMessage($chat_id, "❌ هنوز در تمام کانال‌ها عضو نشده‌اید!", getForceJoinKeyboard());
        }
    }
}
// پردازش پست‌های کانال
elseif (isset($update[\'channel_post\'])) {
    $channel_post = $update[\'channel_post\'];
    $chat_id = $channel_post[\'chat\'][\'id\'];
    $message_id = $channel_post[\'message_id\'];
    
    if (!in_array($chat_id, $data[\'channels\'])) {
        $data[\'channels\'][] = $chat_id;
        $data[\'stats\'][\'active_channels\'] = count($data[\'channels\']);
        saveData($data);
    }
    
    if (!empty($data[\'reactions\'])) {
        $max_reactions = $data[\'max_reactions_per_post\'] ?? 0;
        $reactions_to_send = $data[\'reactions\'];
        
        if ($max_reactions > 0 && $max_reactions < count($reactions_to_send)) {
            $reactions_to_send = array_slice($reactions_to_send, 0, $max_reactions);
        }
        
        foreach ($reactions_to_send as $index => $reaction) {
            if ($index > 0) {
                sleep(2);
            }
            
            $result = sendReaction($chat_id, $message_id, $reaction);
            
            if ($result[\'ok\']) {
                $data[\'stats\'][\'total_reactions\']++;
                saveData($data);
            }
        }
    }
}

// تنظیم webhook
if (isset($_GET[\'set_webhook\'])) {
    $result = sendRequest(\'setWebhook\', [\'url\' => WEBHOOK_URL]);
    echo $result[\'ok\'] ? "✅ Webhook فعال شد!" : "❌ خطا: " . $result[\'description\'];
}

// آمار (تست)
if (isset($_GET[\'stats\'])) {
    $data = getData();
    echo "<h2>آمار ربات:</h2>";
    echo "<p>کانال‌های فعال: " . count($data[\'channels\']) . "</p>";
    echo "<p>کل ری‌اکشن‌ها: " . $data[\'stats\'][\'total_reactions\'] . "</p>";
    echo "<p>ری‌اکشن‌های تنظیم شده: " . implode(\', \', $data[\'reactions\']) . "</p>";
}
?>';

    return $template;
}
?>