<?php
error_reporting(0);
ini_set('display_errors', 0);

// تنظیمات اصلی
define('BOT_TOKEN', '8323167379:AAG-Y0llGq690Jqh95j3J2rYlJN3YXNtB34');
define('ADMIN_ID', 6418982772);
define('WEBHOOK_URL', 'https://helen.ss948.site/reqq/bot.php');
define('POINTS_PER_REFERRAL', 1);
define('POINTS_FOR_BOT_CREATION', 5);

// جوین اجباری
define('FORCE_JOIN_CHANNELS', [
    '@gapzari_chat',
    '@Authentic_Airdrrop'
]);

// ایجاد فایل‌های دیتابیس
if (!file_exists('users.json')) {
    file_put_contents('users.json', json_encode([]));
}
if (!file_exists('bots.json')) {
    file_put_contents('bots.json', json_encode([]));
}
if (!file_exists('referrals.json')) {
    file_put_contents('referrals.json', json_encode([]));
}
if (!file_exists('banned_users.json')) {
    file_put_contents('banned_users.json', json_encode([]));
}

// توابع کمکی
function getUsers() {
    return json_decode(file_get_contents('users.json'), true) ?: [];
}
function getBots() {
    return json_decode(file_get_contents('bots.json'), true) ?: [];
}
function getReferrals() {
    return json_decode(file_get_contents('referrals.json'), true) ?: [];
}
function getBannedUsers() {
    return json_decode(file_get_contents('banned_users.json'), true) ?: [];
}

function saveUsers($data) {
    file_put_contents('users.json', json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}
function saveBots($data) {
    file_put_contents('bots.json', json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}
function saveReferrals($data) {
    file_put_contents('referrals.json', json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}
function saveBannedUsers($data) {
    file_put_contents('banned_users.json', json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

// ارسال درخواست به تلگرام
function sendRequest($method, $parameters = [], $token = null) {
    $bot_token = $token ?: BOT_TOKEN;
    $url = "https://api.telegram.org/bot" . $bot_token . "/" . $method;
    
    $options = [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($parameters),
        CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_TIMEOUT => 30
    ];
    
    $curl = curl_init();
    curl_setopt_array($curl, $options);
    $result = curl_exec($curl);
    $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);
    
    if ($result === false || $http_code !== 200) {
        return ['ok' => false, 'description' => 'Network error'];
    }
    
    return json_decode($result, true) ?: ['ok' => false, 'description' => 'Invalid response'];
}

function sendMessage($chat_id, $text, $reply_markup = null, $token = null) {
    $params = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    
    if ($reply_markup) {
        $params['reply_markup'] = $reply_markup;
    }
    
    return sendRequest('sendMessage', $params, $token);
}

// کیبورد اصلی
function getMainKeyboard() {
    return [
        'keyboard' => [
            [['text' => '🤖 ساخت ربات'], ['text' => '👥 رفرال']],
            [['text' => '📊 آمار من'], ['text' => '🛠 ربات‌های من']],
            [['text' => '📚 راهنما'], ['text' => '☎️ پشتیبانی']]
        ],
        'resize_keyboard' => true
    ];
}

// کیبورد ادمین
function getAdminKeyboard() {
    return [
        'keyboard' => [
            [['text' => '➕ افزایش امتیاز'], ['text' => '➖ کسر امتیاز']],
            [['text' => '📢 پیام همگانی'], ['text' => '📊 آمار کامل']],
            [['text' => '🚫 بن کاربر'], ['text' => '✅ آنبن کاربر']],
            [['text' => '🤖 آمار ربات‌ها'], ['text' => '🔙 منوی اصلی']]
        ],
        'resize_keyboard' => true
    ];
}

// کیبورد ساخت ربات
function getBotCreateKeyboard() {
    return [
        'keyboard' => [
            [['text' => '🏠 منوی اصلی']]
        ],
        'resize_keyboard' => true
    ];
}

// بررسی جوین اجباری
function checkForceJoin($user_id) {
    foreach (FORCE_JOIN_CHANNELS as $channel) {
        $result = sendRequest('getChatMember', [
            'chat_id' => $channel,
            'user_id' => $user_id
        ]);
        
        if (!$result['ok'] || !in_array($result['result']['status'], ['member', 'administrator', 'creator'])) {
            return false;
        }
    }
    return true;
}

// کیبورد جوین اجباری
function getForceJoinKeyboard() {
    $keyboard = [];
    foreach (FORCE_JOIN_CHANNELS as $channel) {
        $keyboard[] = [['text' => "عضویت در $channel", 'url' => "https://t.me/" . ltrim($channel, '@')]];
    }
    $keyboard[] = [['text' => '✅ عضو شدم', 'callback_data' => 'check_join']];
    
    return ['inline_keyboard' => $keyboard];
}

// محاسبه امتیاز کاربر
function getUserPoints($user_id) {
    $referrals = getReferrals();
    $users = getUsers();
    
    $referral_points = count($referrals[$user_id] ?? []) * POINTS_PER_REFERRAL;
    $spent_points = $users[$user_id]['spent_points'] ?? 0;
    $admin_bonus = $users[$user_id]['admin_bonus_points'] ?? 0;
    
    return $referral_points + $admin_bonus - $spent_points;
}

// دریافت آپدیت
$input = file_get_contents('php://input');
$update = json_decode($input, true);

if (!$update) {
    die('No update received');
}

$users = getUsers();
$bots = getBots();
$referrals = getReferrals();
$banned_users = getBannedUsers();

// پردازش پیام‌ها
if (isset($update['message'])) {
    $message = $update['message'];
    $chat_id = $message['chat']['id'];
    $text = $message['text'] ?? '';
    $user_id = $message['from']['id'];
    $first_name = $message['from']['first_name'] ?? 'کاربر';
    
    // بررسی بن
    if (in_array($user_id, $banned_users)) {
        sendMessage($chat_id, "🚫 شما از استفاده از این ربات محروم شده‌اید!");
        exit;
    }
    
    // بررسی جوین اجباری
    if (!checkForceJoin($user_id) && $user_id != ADMIN_ID) {
        $force_msg = "⚠️ <b>برای استفاده از ربات باید در کانال‌های زیر عضو شوید:</b>\n\n";
        foreach (FORCE_JOIN_CHANNELS as $channel) {
            $force_msg .= "📢 $channel\n";
        }
        $force_msg .= "\nپس از عضویت، دکمه 'عضو شدم' را فشار دهید.";
        
        sendMessage($chat_id, $force_msg, getForceJoinKeyboard());
        exit;
    }
    
    // ثبت کاربر جدید
    if (!isset($users[$user_id])) {
        $users[$user_id] = [
            'first_name' => $first_name,
            'join_date' => date('Y-m-d H:i:s'),
            'bots_created' => 0,
            'spent_points' => 0,
            'admin_bonus_points' => 0,
            'referrer' => null
        ];
        
        // پردازش رفرال
        if (preg_match('/\/start (\d+)/', $text, $matches)) {
            $referrer_id = intval($matches[1]);
            if (isset($users[$referrer_id]) && $referrer_id != $user_id) {
                $users[$user_id]['referrer'] = $referrer_id;
                
                if (!isset($referrals[$referrer_id])) {
                    $referrals[$referrer_id] = [];
                }
                $referrals[$referrer_id][] = $user_id;
                
                // اطلاع به معرف
                sendMessage($referrer_id, "🎉 کاربر جدیدی از طریق لینک شما عضو شد!\n\n👤 $first_name\n🔗 تعداد رفرال‌های شما: " . count($referrals[$referrer_id]) . "\n💎 امتیاز جدید: +" . POINTS_PER_REFERRAL . "\n💰 کل امتیاز: " . getUserPoints($referrer_id));
                
                saveReferrals($referrals);
            }
        }
        
        saveUsers($users);
    }
    
    // منوی اصلی
    if ($text == '/start' || $text == '🏠 منوی اصلی') {
        $user_points = getUserPoints($user_id);
        
        $welcome = "🤖 <b>خوش آمدید به رباتساز ری‌اکشن زن!</b>\n\n";
        $welcome .= "👋 سلام $first_name\n\n";
        $welcome .= "🎯 <b>امکانات:</b>\n";
        $welcome .= "• ساخت ربات ری‌اکشن زن شخصی\n";
        $welcome .= "• پنل مدیریت اختصاصی\n";
        $welcome .= "• پشتیبانی کامل\n\n";
        $welcome .= "💎 امتیاز شما: $user_points\n";
        $welcome .= "🎯 هر ساخت ربات: " . POINTS_FOR_BOT_CREATION . " امتیاز\n";
        $welcome .= "👥 هر رفرال: " . POINTS_PER_REFERRAL . " امتیاز";
        
        if ($user_id == ADMIN_ID) {
            $welcome .= "\n\n⚙️ <b>پنل ادمین:</b> /admin";
        }
        
        sendMessage($chat_id, $welcome, getMainKeyboard());
    }
    
    // ادامه در فایل دوم...
    include 'bot_handlers.php';
}

// پردازش callback query
if (isset($update['callback_query'])) {
    $callback = $update['callback_query'];
    $chat_id = $callback['message']['chat']['id'];
    $user_id = $callback['from']['id'];
    
    if ($callback['data'] == 'check_join') {
        if (checkForceJoin($user_id)) {
            sendMessage($chat_id, "✅ تبریک! حالا می‌توانید از تمام امکانات ربات استفاده کنید.", getMainKeyboard());
        } else {
            sendMessage($chat_id, "❌ هنوز در تمام کانال‌ها عضو نشده‌اید!", getForceJoinKeyboard());
        }
    }
}

// تنظیم webhook
if (isset($_GET['set_webhook'])) {
    $result = sendRequest('setWebhook', ['url' => WEBHOOK_URL]);
    if ($result['ok']) {
        echo "✅ Webhook رباتساز تنظیم شد!";
    } else {
        echo "❌ خطا در تنظیم webhook: " . $result['description'];
    }
}

// نمایش آمار
if (isset($_GET['stats'])) {
    $users = getUsers();
    $bots = getBots();
    $referrals = getReferrals();
    
    echo "<h2>آمار رباتساز:</h2>";
    echo "<p>کل کاربران: " . count($users) . "</p>";
    echo "<p>کل ربات‌ها: " . count($bots) . "</p>";
    echo "<p>کل رفرال‌ها: " . array_sum(array_map('count', $referrals)) . "</p>";
}

// دانلود فایل ربات
if (isset($_GET['download']) && isset($_GET['bot_id'])) {
    $bot_id = $_GET['bot_id'];
    $file_path = "bot_$bot_id.php";
    
    if (file_exists($file_path)) {
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="bot_' . $bot_id . '.php"');
        header('Content-Length: ' . filesize($file_path));
        readfile($file_path);
        exit;
    } else {
        echo "فایل پیدا نشد!";
    }
}
?>